# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from ..sdgraphdefinition import *
from ..sdapiobject import *
from ..sdapiobject import *
from ..apiexception import APIException

class SDMDLGraphDefinition(SDGraphDefinition):
    """
    A graph definition based on MDL backend
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDMDLGraphDefinition
        """
        super(SDMDLGraphDefinition, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(id : str) -> SDMDLGraphDefinition:
        """
        Create new SDTypeVoid

        :param id: The id of the outSDMDLGraphDefinition. It has to be unique in the application.
        """
        outSDMDLGraphDefinition = ctypes.c_void_p()
        _res = sd.getContext().SDMDLGraphDefinition_sNew(ctypes.create_string_buffer(id.encode('utf-8')), ctypes.byref(outSDMDLGraphDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDMDLGraphDefinition, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDMDLGraphDefinition.value, ownHandle=True)

